import{i as p,x as o}from"./vendor-uqDZySxZ.js";import{a as c}from"./actions-DQjIolQK.js";import"./FlexibleInput-VqrY3XsW.js";import{a as u,A as h,b as g}from"./index-CAeYBYQn.js";import{g as y}from"./getReferenceIds-CNVIzmHB.js";import{v as m}from"./validateFields-DmXGkKEq.js";import{d as f}from"./dots-horizontal-C32IdcUi.js";import{p as S}from"./plus-WIZf1ABD.js";import"./shoelace-VCI8xL3U.js";class b extends u{static styles=p`
    a {
      color: inherit;
      text-decoration: none;
    }

    .header {
      display: flex;
      justify-content: space-between;
      align-items: center;

      star-button {
        span {
          display: flex;
          svg path {
            fill: var(--sl-color-primary-950);
          }
        }
      }
    }

    section {
      margin: var(--sl-spacing-x-large) 0;
    }

    svg {
      path {
        fill: var(--sl-color-gray-800);
      }
    }

    .id {
      font-family: ui-monospace, 'Cascadia Code', 'Source Code Pro', Menlo, Consolas, 'DejaVu Sans Mono', monospace;
    }
  `;static properties={rawData:{type:Array},groups:{type:Array},isSubmitting:{type:Boolean},tableColumns:{type:Array,state:!0}};constructor(){super(),this.rawData=[],this.groups=[],this.isSubmitting=!1,this.validationRules={id:{type:"string",min:8,max:8},name:{type:"string",min:1,max:64},description:{type:"string",min:0,max:300},groups:{type:"array",min:0,max:10}},this.validationErrorMessage="There are issues that need to be fixed before you can save. Please fix them first.",this.initializeTableColumns()}initializeTableColumns(){this.tableColumns=[{header:"Name",field:"name",link:t=>`/app/systems/${t.id}`},{header:"ID",field:"id",className:"id"},{header:"",type:"actions",actions:[{label:"Edit System",handler:(t,e)=>this.toggleEdit(t,e)},{label:"Remove System",handler:t=>this.handleDelete(t)}]}]}async updated(t){t.has("user")&&(this.api=new h({isLocal:!1,organizationId:this.user.currentOrgId,token:this.token}),await this.loadSystems(),await this.loadGroups())}async loadSystems(){const t=await this.api.getSystems()||[];t.length>0&&t.sort((e,s)=>e.name.localeCompare(s.name)),this.rawData=t}async loadGroups(){const t=await this.api.getGroups()||[];t.length>0&&t.sort((s,i)=>s.name.localeCompare(i.name));const e=t.map(s=>({id:s.id,name:s.name}));this.groups=e}onChange(){this.requestUpdate()}toggleAdd(){const t=this.shadowRoot.querySelector("star-dialog#add-system");t.open=!t.open}toggleEdit(t=null,e=null){const s=this.shadowRoot.querySelector("star-dialog#edit-system");t!==null&&e!==null&&(this.selectedSystem={...t},this.selectedSystemIndex=e,this.requestUpdate()),s.open=!s.open}async onAdd(t){if(this.isSubmitting)return;const e=t.fields.name,s=t.fields.description||"",i=t.fields.groups.map(a=>a.id);if(!m({name:e,description:s,groups:i},{name:this.validationRules.name,description:this.validationRules.description,groups:this.validationRules.groups})){alert(this.validationErrorMessage);return}this.isSubmitting=!0;try{const l={id:await this.api.createSystem({name:e,description:s,groups:i}),name:e,description:s,groups:i};this.rawData=[...this.rawData,l],this.toggleAdd(),this.onChange()}catch(a){console.error("Error adding system:",a),alert(`Failed to add system: ${a.message}`)}finally{this.isSubmitting=!1}}async onEdit(t,e){if(this.isSubmitting)return;if(!this.rawData||e<0||e>=this.rawData.length){console.warn("Invalid index:",e);return}const s=t.fields.id,i=t.fields.name,n=t.fields.description,a=y(t.fields.groups)||[];if(!m({id:s,name:i,description:n,groups:a},{id:this.validationRules.id,name:this.validationRules.name,description:this.validationRules.description,groups:this.validationRules.groups})){alert(this.validationErrorMessage);return}this.isSubmitting=!0;try{const d={...this.rawData[e],name:i,description:n,groups:a};await this.api.updateSystem(s,d),this.rawData=[...this.rawData.slice(0,e),d,...this.rawData.slice(e+1)],this.toggleEdit(),this.onChange()}catch(r){console.error("Error updating system:",r),alert(`Failed to update system: ${r.message}`)}finally{this.isSubmitting=!1}}async onDelete(t){try{await this.api.deleteSystem(t.id),this.rawData=this.rawData.filter(e=>e.id!==t.id),this.onChange()}catch(e){console.error("Error deleting system:",e),alert(`Failed to delete system: ${e.message}`)}}async handleDelete(t){confirm("Are you sure you want to delete this system?")&&await this.onDelete(t)}portal(){return o`
      <portal-entrance
        destination="actions"
        styles=${c.cssText}
      >
        <div class="actions">
          ${o`
            <star-button
              variant="neutral"
              size="small"
              outline
              @click=${()=>this.toggleAdd()}
            >
              <span slot="prefix">${S}</span>
              Add System
            </star-button>
          `}
        </div>
      </portal-entrance>`}render(){return this.rawData?o`
      ${this.portal()}

      <section class="systems">
        <div class="header">
          <text-component type="h1">Systems</text-component>
        </div>

        <star-table
          .data=${this.rawData}
          .columns=${this.tableColumns}
          .searchable=${!0}
          .searchFields=${["name","id"]}
          .searchPlaceholder=${"Search systems..."}
          .searchIcon=${g}
          .actionsIcon=${f}
          .emptyMessage=${"No Systems Found"}
        ></star-table>
      </section>

      <star-dialog id="add-system" label="Add System">
        <flexible-input
          .fields=${{name:"",description:"",groups:[]}}
          .labels=${{name:"Name",description:"Description",groups:"Groups"}}
          .options=${{groups:this.groups}}
          .optionsConfig=${{groups:{multiSelect:!0,objectOptions:!0,labelProp:"name",valueProp:"id"}}}
          .validation=${this.validationRules}
          .isSubmitting=${this.isSubmitting}
          .onAdd=${this.onAdd.bind(this)}
          .onCancel=${()=>this.toggleAdd()}
        ></flexible-input>
      </star-dialog>

      <star-dialog id="edit-system" label="Edit System">
        <flexible-input
          mode="edit"
          .fields=${{id:this.selectedSystem?.id,name:this.selectedSystem?.name,description:this.selectedSystem?.description,groups:this.selectedSystem?.groups}}
          .labels=${{id:"ID",name:"Name",description:"Description",groups:"Groups"}}
          .options=${{groups:this.groups}}
          .optionsConfig=${{groups:{multiSelect:!0,objectOptions:!0,labelProp:"name",valueProp:"id"}}}
          .validation=${this.validationRules}
          .immutable=${["id"]}
          .isSubmitting=${this.isSubmitting}
          .onAdd=${t=>this.onEdit(t,this.selectedSystemIndex)}
          .onCancel=${()=>this.toggleEdit()}
        ></flexible-input>
      </star-dialog>
    `:o`<spinner-component></spinner-component>`}}window.customElements.define("systems-view",b);export{b as SystemsView};
