import{a as y,i as $,x as r}from"./vendor-uqDZySxZ.js";class O extends y{static styles=$`
    .table-container {
      width: 100%;
    }

    .table-filter {
      margin: 0 0 var(--sl-spacing-large) 0;
      display: flex;

      .filter-text {
        width: 30%;
        min-width: 240px;
        margin-right: var(--sl-spacing-medium);
      }
    }

    .data-table {
      width: 100%;
      border-collapse: collapse;
      font-size: var(--sl-font-size-medium);

      thead {
        tr {
          border-bottom: 2px solid var(--color-divider);
        }

        th {
          text-align: left;
          padding: var(--sl-spacing-small) var(--sl-spacing-medium);
          font-weight: 600;
          color: var(--sl-color-gray-700);

          &:last-child {
            width: 60px;
            text-align: center;
          }
        }
      }

      tbody {
        tr {
          border-bottom: 1px solid var(--color-divider);

          &:last-child {
            border-bottom: none;
          }

          &:hover {
            background-color: var(--sl-color-gray-200);
            transition: 0.2s;
          }
        }

        td {
          padding: var(--sl-spacing-small) var(--sl-spacing-medium);
          height: 3rem;
          vertical-align: middle;

          &.actions {
            text-align: left;
          }
        }
      }
    }

    .empty-state {
      text-align: center;
      padding: var(--sl-spacing-x-large);
      color: var(--sl-color-gray-600);
    }

    a {
      color: inherit;
      text-decoration: none;
    }

    svg path {
      fill: var(--sl-color-gray-800);
    }

    .id {
      font-family: ui-monospace, 'Cascadia Code', 'Source Code Pro', Menlo, Consolas, 'DejaVu Sans Mono', monospace;
      font-weight: var(--sl-font-weight-light);
    }
  `;static properties={data:{type:Array},columns:{type:Array},searchable:{type:Boolean},searchFields:{type:Array},searchPlaceholder:{type:String},searchIcon:{type:Object},emptyMessage:{type:String},actionsIcon:{type:Object},filteredData:{type:Array,state:!0},searchText:{type:String,state:!0}};constructor(){super(),this.data=[],this.columns=[],this.searchable=!1,this.searchFields=[],this.searchPlaceholder="Search...",this.emptyMessage="No data found",this.filteredData=[],this.searchText=""}updated(t){t.has("data")&&this.applyFilter()}applyFilter(){if(!this.searchable||!this.searchText||this.searchText.trim()===""){this.filteredData=[...this.data];return}const t=this.searchText.toLowerCase().trim();this.filteredData=this.data.filter(s=>this.searchFields.some(e=>s[e]?.toString().toLowerCase().includes(t)))}updateSearchText(t){this.searchText=t.target.value,this.applyFilter()}renderCell(t,s,e){if(t.render)return t.render(s,e);const i=s[t.field];if(t.link){const o=typeof t.link=="function"?t.link(s):t.link.replace(":id",s.id);return r`<a href="${o}">${i}</a>`}return t.className?r`<span class="${t.className}">${i}</span>`:i}renderActions(t,s){const e=this.columns.find(i=>i.type==="actions");return!e||!e.actions?r``:r`
      <sl-dropdown distance="-10" skidding="5">
        <div slot="trigger">${this.actionsIcon}</div>
        <sl-menu>
          ${e.actions.map(i=>r`
            <star-menu-item @click=${()=>i.handler(t,s)}>
              ${i.label}
            </star-menu-item>
          `)}
        </sl-menu>
      </sl-dropdown>
    `}render(){return r`
      <div class="table-container">
        ${this.searchable?r`
          <div class="table-filter">
            <star-input
              class="filter-text"
              placeholder="${this.searchPlaceholder}"
              value="${this.searchText||""}"
              type="text"
              @input=${this.updateSearchText}
            >
              ${this.searchIcon?r`<span slot="prefix">${this.searchIcon}</span>`:""}
            </star-input>
          </div>
        `:""}

        ${this.filteredData.length>0?r`
          <table class="data-table">
            <thead>
              <tr>
                ${this.columns.map(t=>r`
                  <th>${t.header}</th>
                `)}
              </tr>
            </thead>
            <tbody>
              ${this.filteredData.map((t,s)=>r`
                <tr>
                  ${this.columns.map(e=>r`
                    <td class="${e.className||""} ${e.type==="actions"?"actions":""}">
                      ${e.type==="actions"?this.renderActions(t,s):this.renderCell(e,t,s)}
                    </td>
                  `)}
                </tr>
              `)}
            </tbody>
          </table>
        `:r`
          <div class="empty-state">
            <text-component><em>${this.emptyMessage}</em></text-component>
          </div>
        `}
      </div>
    `}}customElements.define("star-table",O);class S extends y{static styles=$`
    form {
      margin-top: calc(var(--sl-spacing-medium) * -1);
    }

    star-input,
    star-select {
      margin-bottom: var(--sl-spacing-large);
    }

    /* Invalid state styling for inputs */
    star-input[data-invalid]::part(base) {
      border-color: var(--sl-color-red-700);
    }

    star-input[data-invalid]::part(label) {
      color: var(--sl-color-red-700);
    }

    star-input[data-invalid]:focus-within::part(base) {
      border-color: var(--sl-color-red-700);
      box-shadow: 0 0 0 var(--sl-focus-ring-width) var(--sl-color-red-700);
    }

    /* Invalid state styling for selects */
    star-select[data-invalid]::part(combobox) {
      border-color: var(--sl-color-red-700);
    }

    star-select[data-invalid]::part(label) {
      color: var(--sl-color-red-700);
    }

    star-select[data-invalid]:focus-within::part(combobox) {
      border-color: var(--sl-color-red-700);
      box-shadow: 0 0 0 var(--sl-focus-ring-width) var(--sl-color-red-700);
    }

    /* Error message styling */
    .error-message {
      color: var(--sl-color-red-700);
      font-size: 0.875rem;
      margin-top: calc(var(--sl-spacing-2x-small) * -1);
      margin-bottom: var(--sl-spacing-medium);
      display: block;
    }

    star-divider {
      margin: var(--sl-spacing-medium) calc(var(--sl-spacing-large) * -1);
    }

    star-option span svg {
      float: left;
      margin: 2px var(--sl-spacing-x-small) 0 0;
      fill: white;
    }

    star-option .prefix-icon {
      display: inline-block;
      vertical-align: middle;
      margin-right: var(--sl-spacing-x-small);

      svg path {
        fill: var(--sl-color-gray-900) !important;
      }
    }

    .footer {
      margin-bottom: var(--sl-spacing-medium);
      display: flex;
      justify-content: flex-end;
    }

    .footer star-button {
      margin-left: var(--sl-spacing-x-small);
    }
  `;static properties={fields:{type:Object},immutable:{type:Array},isSubmitting:{type:Boolean},isValid:{type:Boolean,state:!0},labels:{type:Object},mode:{type:String},onAdd:{type:Function},onCancel:{type:Function},options:{type:Object},optionsConfig:{type:Object},validation:{type:Object},fieldErrors:{type:Object,state:!0}};constructor(){super(),this.fields={},this.labels={},this.options={},this.optionsConfig={},this.validation={},this.immutable=[],this.isSubmitting=!1,this.mode="add",this.isValid=!1,this.fieldErrors={}}render(){return r`
      <form @submit=${this.handleSubmit}>
        <star-divider></star-divider>
        ${Object.keys(this.fields).map(t=>this.renderField(t))}
        <star-divider></star-divider>
        <div class="footer">
          <star-button
            variant="neutral"
            type="button"
            size="small"
            @click=${this.handleCancel}
          >
            Cancel
          </star-button>
          <star-button
            variant="primary"
            type="submit"
            size="small"
            ?disabled=${this.isSubmitting||!this.isValid}
          >
            ${this.mode==="edit"?"Update":"Save"}
          </star-button>
        </div>
      </form>
    `}isEmailValid(t){return/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(t)}getErrorMessage(t){const s=this.fields[t],e=this.validation[t],i=this.labels[t]||t;if(!e)return"";if(e.type==="array"){const d=Array.isArray(s)?s:[];return e.min!==void 0&&d.length<e.min?`${i} must have at least ${e.min} item${e.min!==1?"s":""}`:e.max!==void 0&&d.length>e.max?`${i} must have no more than ${e.max} item${e.max!==1?"s":""}`:""}const o=typeof s=="string"?s.trim():String(s||"");return e.min!==void 0&&o.length<e.min?`${i} must be at least ${e.min} characters`:e.max!==void 0&&o.length>e.max?`${i} must be no more than ${e.max} characters`:e.type==="email"&&o.length>0&&!this.isEmailValid(o)?"Please enter a valid email address":""}validateFields(){const t={};Object.keys(this.fields).forEach(s=>{const e=this.getErrorMessage(s);e&&(t[s]=e)}),this.fieldErrors=t,this.isValid=Object.keys(t).length===0}renderField(t){const s=this.labels[t]||t,e=this.fields[t]||"",i=this.options[t],o=this.immutable.includes(t),d=this.optionsConfig[t]||{},c=d.multiSelect===!0,h=d.objectOptions===!0,l=d.labelProp||"name",a=d.valueProp||"id",u=d.iconProp,m=this.fieldErrors[t];if(i&&i.length>0)return r`
        <star-select
          label="${s}"
          ?disabled=${o||i.length===0||this.isSubmitting}
          ?multiple=${c}
          ?data-invalid=${m}
          @sl-change="${n=>this.handleInput(n,t)}"
        >
          ${i.map(n=>{let p=!1;const g=h||typeof n=="object"?n[a]:n.toLowerCase(),b=h?n[l]:n,v=u&&h?n[u]:null;return c&&Array.isArray(e)?h?p=e.some(f=>typeof f=="object"?f[a]===n[a]:f===n[a]):p=e.some(f=>typeof f=="string"&&f.toLowerCase()===n.toLowerCase()):h?p=typeof e=="object"?e[a]===n[a]:e===n[a]:p=e===n,r`
              <star-option
                value="${g}"
                ?selected=${p}
              >
                ${v?r`<span class="prefix-icon">${v}</span>`:""}
                ${b}
              </star-option>
            `})}
        </star-select>
        ${m?r`<span class="error-message">${m}</span>`:""}
      `;{const n=this.validation[t]||{},p=this.options[t]&&this.options[t].length===0,g=n.type==="email"?"email":"text";return r`
        <star-input
          type="${g}"
          label="${s}"
          .value="${e}"
          .validation="${n}"
          ?disabled=${o||p||this.isSubmitting}
          ?data-invalid=${m}
          @input="${b=>this.handleInput(b,t)}"
        ></star-input>
        ${m?r`<span class="error-message">${m}</span>`:""}
      `}}handleInput(t,s){if(this.immutable.includes(s)||this.isSubmitting)return;const e=this.optionsConfig[s]||{},i=e.multiSelect===!0,o=e.objectOptions===!0,d=e.valueProp||"id";if(i&&t.target.tagName.toLowerCase()==="star-select"){const c=Array.from(t.target.selectedOptions||[]).map(h=>{const l=h.value;return o?this.options[s].find(u=>u[d]===l)||l:this.options[s].find(u=>u.toLowerCase()===l)||l});this.fields={...this.fields,[s]:c}}else{const c=t.target.value;if(o&&this.options[s]){const h=this.options[s].find(l=>l[d]===c);h?this.fields={...this.fields,[s]:h}:this.fields={...this.fields,[s]:c}}else this.fields={...this.fields,[s]:c}}this.validateFields()}updated(t){super.updated(t),t.has("fields")&&(this.validateFields(),this.updateComplete.then(()=>{this.shadowRoot.querySelectorAll("star-select").forEach(e=>{const i=Object.keys(this.labels).find(l=>this.labels[l]===e.label);if(!i)return;const o=this.optionsConfig[i]||{},d=o.objectOptions===!0,c=o.valueProp||"id";if(o.multiSelect===!0){if(i&&Array.isArray(this.fields[i])&&this.fields[i].length>0){const l=this.fields[i].map(a=>d?typeof a=="object"?a[c]:a:typeof a=="string"?a.toLowerCase():a);JSON.stringify(e.value)!==JSON.stringify(l)&&(e.value=l)}}else{const l=this.fields[i];let a;d&&typeof l=="object"?a=l[c]:a=l,e.value!==a&&(e.value=a)}})}))}firstUpdated(){this.validateFields(),this.requestUpdate()}handleCancel(){this.onCancel()}handleSubmit(t){t.preventDefault(),this.onAdd({fields:this.fields,mode:this.mode})}}customElements.define("flexible-input",S);
