import{a as P,i as A,x as a}from"./vendor-uqDZySxZ.js";import{c as L,A as R,a as U,b as I}from"./index-CAeYBYQn.js";import{g as F,a as b,l as W,d as O,k as j,s as V,b as q,c as _,f as B,e as H}from"./getReferenceNameById-CPPLrwuq.js";import{a as Y}from"./actions-DQjIolQK.js";import{c as J}from"./Main-B0ZaWdn5.js";import{p as K}from"./plus-WIZf1ABD.js";import"./shoelace-VCI8xL3U.js";class Q extends P{static properties={data:{type:Object},domains:{type:Array},groups:{type:Array},systems:{type:Array},healthScore:{type:Object}};static styles=A`
    star-card {
      transition: 0.2s;

      display: flex;
      border-radius: var(--sl-border-radius-medium);
      border: 1px solid var(--color-divider);

      a {
        display: flex;
        flex-direction: row;
        align-items: flex-start;
      }

      .card-inner {
        flex-grow: 1;

        .date {
          color: var(--sl-color-gray-800);
          margin-bottom: var(--sl-spacing-x-small);
        }

        .tags {
          display: flex;
          flex-wrap: wrap;

          star-tag {
            width: auto;
          }

          .owner {
            line-height: 24px;

            .initials::part(base) {
              background-color: var(--sl-color-gray-600);
            }
          }
        }

        .card-header {
          display: flex;
          justify-content: space-between;
          align-items: center;

          .score {
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            width: 30px;
            height: 30px;
            position: relative;
            border-width: 2px;
            border-style: solid;

            &::before {
              content: "";
              position: absolute;
              top: -2px;
              left: -2px;
              width: calc(100% + 4px);
              height: calc(100% + 4px);
              border-radius: 50%;
            }

            &.grade-0 {
              background-color: var(--sl-color-gray-300);
              color: var(--sl-color-gray-950);
              border-color: var(--sl-color-gray-400);

              &::before {
                background: conic-gradient(
                  var(--color-divider) 0deg 10deg,
                  transparent 10deg 360deg
                );

                mask: radial-gradient(
                  farthest-side,
                  transparent calc(100% - 3px),
                  black calc(100% - 3px)
                );
              }
            }

            &.grade-f {
              background-color: var(--color-health-f);
              color: var(--color-health-f-contrast);
              border-color: var(--color-health-f-outline);

              &::before {
                background: conic-gradient(
                  var(--color-health-f-contrast) 0deg 20deg,
                  transparent 20deg 360deg
                );

                mask: radial-gradient(
                  farthest-side,
                  transparent calc(100% - 3px),
                  black calc(100% - 3px)
                );
              }
            }

            &.grade-e {
              background-color: var(--color-health-e);
              color: var(--color-health-e-contrast);
              border-color: var(--color-health-e-outline);

              &::before {
                background: conic-gradient(
                  var(--color-health-e-contrast) 0deg 88deg,
                  transparent 88deg 360deg
                );

                mask: radial-gradient(
                  farthest-side,
                  transparent calc(100% - 3px),
                  black calc(100% - 3px)
                );
              }
            }

            &.grade-d {
              background-color: var(--color-health-d);
              color: var(--color-health-d-contrast);
              border-color: var(--color-health-d-outline);

              &::before {
                background: conic-gradient(
                  var(--color-health-d-contrast) 0deg 156deg,
                  transparent 156deg 360deg
                );

                mask: radial-gradient(
                  farthest-side,
                  transparent calc(100% - 3px),
                  black calc(100% - 3px)
                );
              }
            }

            &.grade-c {
              background-color: var(--color-health-c);
              color: var(--color-health-c-contrast);
              border-color: var(--color-health-c-outline);

              &::before {
                background: conic-gradient(
                  var(--color-health-c-contrast) 0deg 224deg,
                  transparent 224deg 360deg
                );

                mask: radial-gradient(
                  farthest-side,
                  transparent calc(100% - 3px),
                  black calc(100% - 3px)
                );
              }
            }

            &.grade-b {
              background-color: var(--color-health-b);
              color: var(--color-health-b-contrast);
              border-color: var(--color-health-b-outline);

              &::before {
                background: conic-gradient(
                  var(--color-health-b-contrast) 0deg 292deg,
                  transparent 292deg 360deg
                );

                mask: radial-gradient(
                  farthest-side,
                  transparent calc(100% - 3px),
                  black calc(100% - 3px)
                );
              }
            }

            &.grade-a {
              background-color: var(--color-health-a);
              color: var(--color-health-a-contrast);
              border-color: var(--color-health-a-outline);

              &::before {
                background: conic-gradient(
                  var(--color-health-a-contrast) 0deg 360deg,
                  transparent 360deg 360deg
                );

                mask: radial-gradient(
                  farthest-side,
                  transparent calc(100% - 3px),
                  black calc(100% - 3px)
                );
              }
            }
          }
        }
      }

      &::part(base) {
        border: none;
        flex-grow: 1;
      }

      &::part(body) {
        padding: var(--sl-spacing-medium);
      }

      &:hover {
        cursor: pointer;
        transition: 0.2s;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
      }

      a {
        text-decoration: none;
        color: inherit;
      }

      star-tag {
        margin-right: var(--sl-spacing-x-small);
      }

      star-tag svg {
        margin-right: var(--sl-spacing-2x-small);
      }

      star-tag svg path {
        fill: var(--sl-color-gray-950);
      }

      .description {
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
        word-wrap: break-word;
        max-width: 348px;
        max-height: 3.6em;
        margin: var(--sl-spacing-small) 0;
      }

      .date {
        font-size: var(--sl-font-size-small);
      }

      .contacts {
        display: table;
        padding: var(--sl-spacing-x-small) var(--sl-spacing-medium);

        .headers {
          font-weight: var(--sl-font-weight-semibold);
        }

        .headers,
        .contact {
          font-size: var(--sl-font-size-x-small);
          display: table-row;

          span {
            display: table-cell;
            border-bottom: 1px solid var(--color-divider);
            padding: var(--sl-spacing-small) 0;

            &:first-child {
              padding-right: var(--sl-spacing-medium);
            }
          }

          &:last-child {
            span {
              border-bottom: none;
            }
          }
        }
      }

      .api-list {
        display: table;
        padding: var(--sl-spacing-x-small) var(--sl-spacing-medium);

        .headers {
          font-weight: var(--sl-font-weight-semibold);
        }

        .headers,
        .api-item {
          font-size: var(--sl-font-size-x-small);
          display: table-row;

          span {
            display: table-cell;
            border-bottom: 1px solid var(--color-divider);
            padding: var(--sl-spacing-small) 0;
          }

          &:last-child {
            span {
              border-bottom: none;
            }
          }
        }
      }
    }
  `;render(){if(!this.data)return a``;let t=this.healthScore;t||(t={score:0,grade:"-"});const s=`${L(!1).appBase}/record/${this.data.id}`;return a`<star-card class="card-header">
      <a href="${s}">
        <div class="card-inner">
          <div class="card-header">
            <div class="title">

              <div class="date">
                Updated: ${new Date(parseInt(this.data.changed,10)).toLocaleString()}
              </div>

              <div class="name">
                <strong>${this.data.name}</strong>
              </div>
            </div>

            <span class="score grade-${t.grade&&t.grade!=="-"?t.grade.toLowerCase():"0"}">
              ${t.grade?.toUpperCase()??"-"}
            </span>
          </div>

          <div class="description">
            <text-component size="xs" noMargin>
              ${this.data.description}
            </text-component>
          </div>

          <div class="tags">
            ${this.data.domain?a`<star-tag style="domain_link" size="small" .value="${F(this.domains,this.data.domain)||"?"}"></star-tag>`:""}
            ${this.data.system?a`<star-tag style="system_link" size="small" .value="${F(this.systems,this.data.system)||"?"}"></star-tag>`:""}
            ${this.data.group?a`<star-tag style="group_link" size="small" .value="${F(this.groups,this.data.group)||"?"}"></star-tag>`:""}
            ${this.data.type?a`<star-tag style="kind" size="small" .value="${this.data.type}"></star-tag>`:""}
            ${this.data.stage?a`<star-tag style="lifecycle" size="small" .value="${b(W,this.data.stage)||"?"}"></star-tag>`:""}
            ${this.data.version?a`<star-tag size="small" .value="Version ${this.data.version}"}"></star-tag>`:""}
            ${this.data.contacts.length>0?a`
                    <sl-dropdown distance="10" placement="top-end" data-dropdown="contacts">
                      <star-tag
                        slot="trigger"
                        size="small"
                        type="info"
                        style="user_link"
                        @mouseenter=${e=>this.showDropdown(e)}
                        @mouseleave=${e=>this.hideDropdown(e)}
                        .value="Contacts: ${this.data.contacts.length}"
                      >
                      </star-tag>

                      <sl-menu class="contacts">
                        <div class="headers">
                          <span>Email</span>
                          <span>Relationship</span>
                        </div>
                        ${this.data.contacts.map(e=>a`<div class="contact">
                            <span>${e.email}</span>
                            <span>${J(e.relation)}</span>
                          </div>`)}
                      </sl-menu>
                    </sl-dropdown>
                  `:""}
            ${this.data.api.length>0?a`
                    <sl-dropdown distance="10" placement="top-end" data-dropdown="api">
                      <star-tag
                        slot="trigger"
                        size="small"
                        type="info"
                        style="code"
                        @mouseenter=${e=>this.showDropdown(e)}
                        @mouseleave=${e=>this.hideDropdown(e)}
                        .value="APIs: ${this.data.api.length}"
                      >
                      </star-tag>

                      <sl-menu class="api-list">
                        <div class="headers">
                          <span>API name</span>
                        </div>
                        ${this.data.api.map(e=>a`<div class="api-item">
                            <span>${e.name}</span>
                          </div>`)}
                      </sl-menu>
                    </sl-dropdown>
                  `:""}
            ${this.data.dataSensitivity?a`<star-tag style="criticality" size="small" .value="Data Sensitivity: ${b(O,this.data.dataSensitivity)||"?"}"></star-tag>`:""}

          </div>
        </div>
      </a>
    </star-card>`}showDropdown(t){const s=t.target.closest("sl-dropdown");s&&s.show()}hideDropdown(t){const s=t.target.closest("sl-dropdown");s&&s.hide()}}customElements.define("catalog-record",Q);function v(C,t,s=null){let e;return s?e=C.flatMap(i=>{const n=i[t];return n?n.map(d=>d[s.property]):[]}).filter(Boolean):e=C.map(i=>i[t]).filter(Boolean),[...new Set(e)].sort()}class X extends P{static properties={catalogData:{type:Array},values:{type:Object},domains:{type:Array},groups:{type:Array},systems:{type:Array},filter:{type:Function},handleFilterGroup:{type:Function},handleFilterGrade:{type:Function},handleFilterStage:{type:Function},handleFilterContact:{type:Function},handleFilterDomain:{type:Function},handleFilterSystem:{type:Function},handleFilterType:{type:Function},handleFilterDataSensitivity:{type:Function},handleFilterSourcingModel:{type:Function},handleFilterDeploymentModel:{type:Function},handleFilterBusinessCriticality:{type:Function},handleFilterTags:{type:Function},selectedGroups:{type:Array},selectedGrades:{type:Array},selectedStages:{type:Array},selectedContacts:{type:Array},selectedDomains:{type:Array},selectedSystems:{type:Array},selectedTypes:{type:Array},selectedDataSensitivities:{type:Array},selectedSourcingModels:{type:Array},selectedDeploymentModels:{type:Array},selectedBusinessCriticality:{type:Array},selectedTags:{type:Array}};static styles=A`
    star-option {
      display: block;
    }

    star-select {
      margin-bottom: var(--sl-spacing-medium);
    }

    .wrapper {
      background-color: var(--sl-color-gray-100);
      border: 1px solid var(--color-divider);
      border-radius: var(--sl-border-radius-medium);
      width: 400px;
    }

    .title {
      padding: var(--sl-spacing-medium);
    }

    star-divider {
      margin: 0;
    }

    .summary {
      display: flex;
      justify-content: space-between;
      flex-grow: 1;

      .clear {
        color: var(--sl-color-primary-900);
        font-size: var(--sl-font-size-small);

        .count {
          border-radius: 50%;
          background-color: var(--sl-color-primary-300);
          width: 22px;
          height: 22px;
          display: inline-flex;
          align-items: center;
          justify-content: center;
        }
      }
    }

    .no-matches {
      margin: var(--sl-spacing-x-small) 0;
      font-style: italic;
      line-height: 42px;
    }

    .health-grade {
      display: flex;
      justify-content: space-between;
      padding: var(--sl-spacing-small) 0 var(--sl-spacing-large) 0;
    }

    .grade-option {
      border-radius: 50%;
      width: 24px;
      height: 24px;
      margin: 0 13px;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      border: 2px solid var(--color-divider);
      cursor: pointer;
      position: relative;

      &.grade-a {
        background-color: var(--color-health-a);
        color: var(--color-health-a-contrast);
        border-color: var(--color-health-a-outline);
      }

      &.grade-b {
        background-color: var(--color-health-b);
        color: var(--color-health-b-contrast);
        border-color: var(--color-health-b-outline);
      }

      &.grade-c {
        background-color: var(--color-health-c);
        color: var(--color-health-c-contrast);
        border-color: var(--color-health-c-outline);
      }

      &.grade-d {
        background-color: var(--color-health-d);
        color: var(--color-health-d-contrast);
        border-color: var(--color-health-d-outline);
      }

      &.grade-e {
        background-color: var(--color-health-e);
        color: var(--color-health-e-contrast);
        border-color: var(--color-health-e-outline);
      }

      &.grade-f {
        background-color: var(--color-health-f);
        color: var(--color-health-f-contrast);
        border-color: var(--color-health-f-outline);
      }

      &.selected::before {
        content: " ";
        position: absolute;
        display: block;
        width: 34px;
        height: 34px;
        top: -7px;
        left: -7px;
        border-radius: 50%;
        border: 3px solid var(--color-primary);
      }
    }

    .footer {
      display: flex;
      justify-content: flex-end;
      margin: var(--sl-spacing-medium);
    }
  `;async firstUpdated(){const t=this.shadowRoot.querySelectorAll("fixed-details");t.forEach(o=>{o.addEventListener("sl-show",()=>{t.forEach(y=>{y!==o&&y.hide()})})});const s=v(this.catalogData,"contacts",{property:"email"}),e=v(this.catalogData,"dataSensitivity"),i=["A","B","C","D","E","F","-"],n=v(this.catalogData,"domain"),d=v(this.catalogData,"group"),c=v(this.catalogData,"stage"),h=v(this.catalogData,"system"),p=v(this.catalogData,"kind"),g=v(this.catalogData,"sourcingModel"),m=v(this.catalogData,"deploymentModel"),u=v(this.catalogData,"businessCriticality"),l=this.catalogData.flatMap(o=>o.tags||[]).filter(o=>o&&o.trim()!==""),r=[...new Set(l)].sort();this.values={businessCriticalities:u,contacts:s,dataSensitivities:e,deploymentModels:m,domains:n,grades:i,groups:d,sourcingModels:g,stages:c,systems:h,types:p,tags:r}}handleGroupsChange(t){this.selectedGroups=t.detail,this.handleFilterGroup(t.detail)}clearGroups(t){t?.stopPropagation(),this.handleGroupsChange({detail:[]})}handleGradesChange(t){this.selectedGrades=this.selectedGrades?.includes(t)?this.selectedGrades.filter(s=>s!==t):[...this.selectedGrades??[],t],this.handleFilterGrade(this.selectedGrades)}clearGrades(t){t?.stopPropagation(),this.selectedGrades=[],this.handleFilterGrade([])}handleStagesChange(t){this.selectedStages=t.detail,this.handleFilterStage(t.detail)}clearStages(t){t?.stopPropagation(),this.handleStagesChange({detail:[]})}handleContactsChange(t){this.selectedContacts=t.detail,this.handleFilterContact(t.detail)}clearContacts(t){t?.stopPropagation(),this.handleContactsChange({detail:[]})}handleDomainsChange(t){this.selectedDomains=t.detail,this.handleFilterDomain(t.detail)}clearDomains(t){t?.stopPropagation(),this.handleDomainsChange({detail:[]})}handleSystemsChange(t){this.selectedSystems=t.detail,this.handleFilterSystem(t.detail)}clearSystems(t){t?.stopPropagation(),this.handleSystemsChange({detail:[]})}handleTypesChange(t){this.selectedTypes=t.detail,this.handleFilterType(t.detail)}clearTypes(t){t?.stopPropagation(),this.handleTypesChange({detail:[]})}handleDataSensitivitiesChange(t){this.selectedDataSensitivities=t.detail,this.handleFilterDataSensitivity(t.detail)}clearDataSensitivities(t){t?.stopPropagation(),this.handleDataSensitivitiesChange({detail:[]})}handleSourcingModelsChange(t){this.selectedSourcingModels=t.detail,this.handleFilterSourcingModel(t.detail)}clearSourcingModels(t){t?.stopPropagation(),this.handleSourcingModelsChange({detail:[]})}handleDeploymentModelsChange(t){this.selectedDeploymentModels=t.detail,this.handleFilterDeploymentModel(t.detail)}clearDeploymentModels(t){t?.stopPropagation(),this.handleDeploymentModelsChange({detail:[]})}handleBusinessCriticalityChange(t){this.selectedBusinessCriticality=t.detail,this.handleFilterBusinessCriticality(t.detail)}clearBusinessCriticality(t){t?.stopPropagation(),this.handleBusinessCriticalityChange({detail:[]})}handleTagsChange(t){this.selectedTags=t.detail,this.handleFilterTags(t.detail)}clearTags(t){t?.stopPropagation(),this.handleTagsChange({detail:[]})}clearFilters(){this.clearBusinessCriticality(),this.clearContacts(),this.clearDataSensitivities(),this.clearDeploymentModels(),this.clearDomains(),this.clearGrades(),this.clearGroups(),this.clearSourcingModels(),this.clearStages(),this.clearSystems(),this.clearTags(),this.clearTypes()}filterCatalog(t,s,e,i,n,d,c,h,p,g,m,u){return this.catalogData.filter(l=>{if(t&&t.length>0&&!t.includes(l.group)||s&&s.length>0&&!s.includes(l.grade)||e&&e.length>0&&!e.includes(l.stage))return!1;if(i&&i.length>0){const r=l.contacts||[];if(!i.some(y=>r.some(f=>f.email===y)))return!1}if(n&&n.length>0&&!n.includes(l.domain)||d&&d.length>0&&!d.includes(l.system)||c&&c.length>0&&!c.includes(l.kind)||h&&h.length>0&&!h.includes(l.dataSensitivity)||p&&p.length>0&&!p.includes(l.sourcingModel)||g&&g.length>0&&!g.includes(l.deploymentModel)||m&&m.length>0&&!m.includes(l.businessCriticality))return!1;if(u&&u.length>0){const r=l.tags||[];if(!u.some(y=>r.includes(y)))return!1}return!0})}applyFilter(t,s,e,i,n,d,c,h,p,g,m,u){const l=t?[t]:this.selectedGroups??[],r=s?[s]:this.selectedGrades??[],o=e?[e]:this.selectedStages??[],y=i?[i]:this.selectedContacts??[],f=n?[n]:this.selectedDomains??[],S=d?[d]:this.selectedSystems??[],x=c?[c]:this.selectedTypes??[],$=h?[h]:this.selectedDataSensitivities??[],w=p?[p]:this.selectedSourcingModels??[],D=g?[g]:this.selectedDeploymentModels??[],M=m?[m]:this.selectedBusinessCriticality??[],k=u?[u]:this.selectedTags??[];return this.filterCatalog(l,r,o,y,f,S,x,$,w,D,M,k).length}countMatchesWithCurrentFilters(t,s){const e=t==="group"?[]:this.selectedGroups??[],i=t==="grade"?[]:this.selectedGrades??[],n=t==="stage"?[]:this.selectedStages??[],d=t==="contact"?[]:this.selectedContacts??[],c=t==="domain"?[]:this.selectedDomains??[],h=t==="system"?[]:this.selectedSystems??[],p=t==="type"?[]:this.selectedTypes??[],g=t==="dataSensitivity"?[]:this.selectedDataSensitivities??[],m=t==="sourcingModel"?[]:this.selectedSourcingModels??[],u=t==="deploymentModel"?[]:this.selectedDeploymentModels??[],l=t==="businessCriticality"?[]:this.selectedBusinessCriticality??[],r=t==="tag"?[]:this.selectedTags??[];let o=e;const y=i;let f=n,S=d,x=c,$=h,w=p,D=g,M=m,k=u,G=l,T=r;return t==="tag"?T=[s]:t==="group"?o=[s]:t==="domain"?x=[s]:t==="system"?$=[s]:t==="contact"?S=[s]:t==="type"?w=[s]:t==="stage"?f=[s]:t==="dataSensitivity"?D=[s]:t==="sourcingModel"?M=[s]:t==="deploymentModel"?k=[s]:t==="businessCriticality"&&(G=[s]),this.filterCatalog(o,y,f,S,x,$,w,D,M,k,G,T).length}renderCheckboxes(t){let s=[];return t==="domains"?s=this.values.domains.map(e=>({value:e,label:F(this.domains,e)||e,count:this.countMatchesWithCurrentFilters("domain",e),disabled:this.countMatchesWithCurrentFilters("domain",e)===0})):t==="systems"?s=this.values.systems.map(e=>({value:e,label:F(this.systems,e)||e,count:this.countMatchesWithCurrentFilters("system",e),disabled:this.countMatchesWithCurrentFilters("system",e)===0})):t==="groups"?s=this.values.groups.map(e=>({value:e,label:F(this.groups,e)||e,count:this.countMatchesWithCurrentFilters("group",e),disabled:this.countMatchesWithCurrentFilters("group",e)===0})):t==="contacts"?s=this.values.contacts.map(e=>({value:e,label:e,count:this.countMatchesWithCurrentFilters("contact",e),disabled:this.countMatchesWithCurrentFilters("contact",e)===0})):t==="types"?s=this.values.types.map(e=>({value:e,label:b(j,e)||"?",count:this.countMatchesWithCurrentFilters("type",e),disabled:this.countMatchesWithCurrentFilters("type",e)===0})):t==="stages"?s=this.values.stages.map(e=>({value:e,label:b(W,e)||"?",count:this.countMatchesWithCurrentFilters("stage",e),disabled:this.countMatchesWithCurrentFilters("stage",e)===0})):t==="dataSensitivities"?s=this.values.dataSensitivities.map(e=>({value:e,label:b(O,e)||"?",count:this.countMatchesWithCurrentFilters("dataSensitivity",e),disabled:this.countMatchesWithCurrentFilters("dataSensitivity",e)===0})):t==="sourcingModels"?s=this.values.sourcingModels.map(e=>({value:e,label:b(V,e)||"?",count:this.countMatchesWithCurrentFilters("sourcingModel",e),disabled:this.countMatchesWithCurrentFilters("sourcingModel",e)===0})):t==="deploymentModels"?s=this.values.deploymentModels.map(e=>({value:e,label:b(q,e)||"?",count:this.countMatchesWithCurrentFilters("deploymentModel",e),disabled:this.countMatchesWithCurrentFilters("deploymentModel",e)===0})):t==="businessCriticalities"?s=this.values.businessCriticalities.map(e=>({value:e,label:b(_,e)||"?",count:this.countMatchesWithCurrentFilters("businessCriticality",e),disabled:this.countMatchesWithCurrentFilters("businessCriticality",e)===0})):t==="tags"&&(s=this.values.tags.map(e=>{const i=this.countMatchesWithCurrentFilters("tag",e);return{value:e,label:e,count:i,disabled:i===0}})),s.sort((e,i)=>e.label.localeCompare(i.label))}render(){return this.values?.contacts?a`<div class="wrapper">
      <div class="title">
        <text-component type="h3" noMargin>Filter</text-component>
      </div>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Health Score</span>
          ${(this.selectedGrades?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearGrades.bind(this)}>Clear</span>
                <span class="count">${this.selectedGrades.length}</span>
              </div>`:""}
        </div>

        <div class="health-grade">
          ${this.values.grades.map(t=>a`
              <div
                class="grade-option grade-${t.toLowerCase()}${this.selectedGrades?.includes(t)?" selected":""}"
                @click=${this.handleGradesChange.bind(this,t)}
              >
                ${t}
              </div>
            `)}
        </div>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Domains</span>
          ${(this.selectedDomains?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearDomains.bind(this)}>Clear</span>
                <span class="count">${this.selectedDomains.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("domains")}
          .value=${this.selectedDomains}
          @star-change=${this.handleDomainsChange.bind(this)}
        >
          <text-component slot="no-matches" class="no-matches" noMargin>
            No matching domains found...
          </text-component>
        </checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Systems</span>
          ${(this.selectedSystems?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearSystems.bind(this)}>Clear</span>
                <span class="count">${this.selectedSystems.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("systems")}
          .value=${this.selectedSystems}
          @star-change=${this.handleSystemsChange.bind(this)}
        >
          <text-component slot="no-matches" class="no-matches" noMargin>
            No matching systems found...
          </text-component>
        </checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Groups</span>
          ${(this.selectedGroups?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearGroups.bind(this)}>Clear</span>
                <span class="count">${this.selectedGroups.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("groups")}
          .value=${this.selectedGroups}
          @star-change=${this.handleGroupsChange.bind(this)}
        >
          <text-component slot="no-matches" class="no-matches" noMargin>
            No matching groups found...
          </text-component>
        </checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Contacts</span>
          ${(this.selectedContacts?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearContacts.bind(this)}>Clear</span>
                <span class="count">${this.selectedContacts.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("contacts")}
          .value=${this.selectedContacts}
          @star-change=${this.handleContactsChange.bind(this)}
        >
          <text-component slot="no-matches" class="no-matches" noMargin>
            No matching contacts found...
          </text-component>
        </checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Type</span>
          ${(this.selectedTypes?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearTypes.bind(this)}>Clear</span>
                <span class="count">${this.selectedTypes.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("types")}
          .value=${this.selectedTypes}
          @star-change=${this.handleTypesChange.bind(this)}
        >
          <text-component slot="no-matches" class="no-matches" noMargin>
            No matching types found...
          </text-component>
        </checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Lifecycle Stage</span>
          ${(this.selectedStages?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearStages.bind(this)}>Clear</span>
                <span class="count">${this.selectedStages.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("stages")}
          .value=${this.selectedStages}
          @star-change=${this.handleStagesChange.bind(this)}
        ></checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Data Sensitivity</span>
          ${(this.selectedDataSensitivities?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearDataSensitivities.bind(this)}>Clear</span>
                <span class="count">${this.selectedDataSensitivities.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("dataSensitivities")}
          .value=${this.selectedDataSensitivities}
          @star-change=${this.handleDataSensitivitiesChange.bind(this)}
        >
          <text-component slot="no-matches" class="no-matches" noMargin>
            No matching data sensitivities found...
          </text-component>
        </checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Sourcing Model</span>
          ${(this.selectedSourcingModels?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearSourcingModels.bind(this)}>Clear</span>
                <span class="count">${this.selectedSourcingModels.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("sourcingModels")}
          .value=${this.selectedSourcingModels}
          @star-change=${this.handleSourcingModelsChange.bind(this)}
        >
          <text-component slot="no-matches" class="no-matches" noMargin>
            No matching sourcing models found...
          </text-component>
        </checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Deployment Model</span>
          ${(this.selectedDeploymentModels?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearDeploymentModels.bind(this)}>Clear</span>
                <span class="count">${this.selectedDeploymentModels.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("deploymentModels")}
          .value=${this.selectedDeploymentModels}
          @star-change=${this.handleDeploymentModelsChange.bind(this)}
        >
          <text-component slot="no-matches" class="no-matches" noMargin>
            No matching deployment models found...
          </text-component>
        </checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Business Criticality</span>
          ${(this.selectedBusinessCriticality?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearBusinessCriticality.bind(this)}>Clear</span>
                <span class="count">${this.selectedBusinessCriticality.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("businessCriticalities")}
          .value=${this.selectedBusinessCriticality}
          @star-change=${this.handleBusinessCriticalityChange.bind(this)}
        >
          <text-component slot="no-matches" class="no-matches" noMargin>
            No matching business criticality levels found...
          </text-component>
        </checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <fixed-details>
        <div slot="summary" class="summary">
          <span>Tags</span>
          ${(this.selectedTags?.length??0)>0?a`<div class="clear">
                <span @click=${this.clearTags.bind(this)}>Clear</span>
                <span class="count">${this.selectedTags.length}</span>
              </div>`:""}
        </div>

        <checkbox-select
          .options=${this.renderCheckboxes("tags")}
          .value=${this.selectedTags}
          @star-change=${this.handleTagsChange.bind(this)}
        >
          <text-component slot="no-matches" class="no-matches" noMargin>
            No matching tags found...
          </text-component>
        </checkbox-select>
      </fixed-details>

      <star-divider></star-divider>

      <div class="footer">
        <star-button variant="neutral" size="small" @click=${this.clearFilters.bind(this)}>
          Clear Filters
        </star-button>
      </div>
    </div>`:""}}customElements.define("catalog-filter",X);class Z extends P{static styles=A`
    form {
      margin-top: calc(var(--sl-spacing-medium) * -1);
    }
    star-borderless-input {
      margin-bottom: var(--sl-spacing-medium);
      &::part(input) {
        font-size: var(--sl-font-size-x-large);
        font-weight: var(--sl-font-weight-bold);
      }
    }
    star-divider {
      margin: var(--sl-spacing-medium) calc(var(--sl-spacing-large) * -1);
    }
    .footer {
      margin-bottom: var(--sl-spacing-medium);
      display: flex;
      justify-content: flex-end;
      star-button {
        margin-left: var(--sl-spacing-x-small);
      }
    }
  `;static properties={name:{type:String},description:{type:String},organizationId:{type:String},token:{type:String},isCreating:{type:Boolean},isSubmitting:{type:Boolean},onCreate:{type:Function},onCancel:{type:Function}};constructor(){super(),this.isSubmitting=!1}async updated(t){t.has("token")&&(this.api=new R({isLocal:!1,organizationId:this.organizationId,token:this.token}))}render(){return a`
      <form @submit=${this.handleSubmit}>
        <star-divider></star-divider>
        <star-borderless-input
          type="text"
          placeholder="Name"
          @input="${this.handleName.bind(this)}"
        >
        </star-borderless-input>
        <star-borderless-textarea
          placeholder="Add Description..."
          @input=${this.handleDescription.bind(this)}
        ></star-borderless-textarea>
        <star-divider></star-divider>
        <div class="footer">
          <star-button
            variant="neutral"
            type="button"
            size="small"
            ?disabled=${this.isCreating||this.isSubmitting}
            @click=${this.handleCancel.bind(this)}
          >Cancel</star-button>
          <star-button
            variant="primary"
            type="submit"
            size="small"
            ?disabled=${this.isSubmitting}
          >Add Record</star-button>
        </div>
      </form>
    `}handleName(t){this.name=t.target.value}handleDescription(t){this.description=t.target.value}handleCancel(){this.name="",this.description="",this.onCancel()}async handleSubmit(t){if(t.preventDefault(),!this.isSubmitting){this.isSubmitting=!0,this.isCreating=!0;try{const s={name:this.name,description:this.description},e=await this.api.createRecord({spec:s});this.onCreate({id:e,...s,changed:Date.now()})}catch(s){console.error("Error creating record:",s)}finally{this.isSubmitting=!1,this.isCreating=!1}}}}customElements.define("create-record",Z);class tt extends P{static styles=A`
    form {
      margin-top: calc(var(--sl-spacing-medium) * -1);
    }

    em {
      font-size: 0.8rem;
    }

    #share-view-url-container {
      display: flex;
      flex-direction: row;

      sl-input {
        width: 100%;
      }
    }

    star-divider {
      margin: var(--sl-spacing-medium) calc(var(--sl-spacing-large) * -1);
    }

    .footer {
      margin-bottom: var(--sl-spacing-medium);
      display: flex;
      justify-content: flex-end;

      star-button {
        margin-left: var(--sl-spacing-x-small);
      }
    }
  `;static properties={onCancel:{type:Function}};async share(){if(navigator.share)try{await navigator.share({title:document.title,url:window.location.href})}catch(t){console.log("Error sharing:",t)}}render(){const t=window.location;return a`
      <form>
        <star-divider></star-divider>

        <div id="share-view-url-container">
          <sl-input disabled value="${t}"></sl-input>

          <sl-copy-button
            value="${t}"
            copy-label="Click to copy"
            success-label="Copied URL"
            error-label="Your browser doesn't support this!"
          ></sl-copy-button>
        </div>

        <star-divider></star-divider>

        <em>Want to save this view? Simply bookmark the page with CTRL+D (Windows) or CMD+D (Mac)!</em>

        <star-divider></star-divider>

        <div class="footer">
          <star-button
            @click="${this.share.bind(this)}"
            variant="neutral"
            size="small"
          >
            Share
          </star-button>

          <star-button
            variant="neutral"
            type="button"
            size="small"
            @click=${this.handleClose.bind(this)}
          >
            Close
          </star-button>
        </div>
      </form>
    `}handleClose(){this.onCancel()}}customElements.define("share-view",tt);class et extends U{static styles=A`
    #catalog {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
      gap: var(--sl-spacing-medium);
    }

    star-tag {
      svg {
        margin-right: var(--sl-spacing-2x-small);

        path {
          fill: var(--sl-color-gray-950);
        }
      }

      &:hover {
        cursor: pointer;
        &::part(base) {
          transition: 0.2s;
          background-color: var(--sl-color-gray-100);
        }
      }
    }

    star-divider {
      margin: var(--sl-spacing-small) calc(var(--sl-spacing-large) * -1);
    }

    .filter-bar {
      display: flex;
      flex-direction: row;

      star-input {
        margin-right: var(--sl-spacing-x-small);

        &::part(base) {
          height: 32px;
        }
      }

      sl-dropdown, star-button {
        margin-right: var(--sl-spacing-x-small);
      }

      star-select {
        margin-left: auto;
        margin-right: var(--sl-spacing-x-small);

        &::part(combobox) {
          height: 32px;
        }
      }

      star-button::part(base) {
        height: 32px;
      }

      svg {
        margin-top: 2px;

        path {
          fill: var(--sl-input-color);
        }
      }

      .filter {
        &::part(base) {
          transition: background-color 0.2s, color 0.2s;
        }

        svg path {
          transition: fill 0.2s;
        }

        &.active {
          &::part(base) {
            background-color: var(--sl-color-primary-200);
            color: var(--sl-color-primary-900);
          }

          svg path {
            fill: var(--sl-color-primary-900);
          }

          .count {
            border-radius: 50%;
            background-color: var(--sl-color-primary-300);
            font-size: var(--sl-font-size-small);
            width: 20px;
            height: 20px;
            line-height: 20px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin-left: var(--sl-spacing-x-small);
          }
        }
      }
    }

    .add {
      margin-top: 6px;
    }
  `;static properties={fromUrlNavigation:{type:Boolean},rawData:{type:Array},filteredData:{type:Array},domains:{type:Array},groups:{type:Array},systems:{type:Array},healthScores:{type:Array},searchText:{type:String},filterStage:{type:String},filterGrade:{type:String},filterGroup:{type:String},filterContact:{type:String},filterDomain:{type:String},filterSystem:{type:String},filterType:{type:String},filterDataSensitivity:{type:String},filterDeploymentModel:{type:String},filterSourcingModel:{type:String},filterBusinessCriticality:{type:String},filterTags:{type:String},sortOption:{type:String},isCreateRecordModalOpen:{type:Boolean}};async updated(t){if(t.has("user")){this.api=new R({isLocal:!1,organizationId:this.user.currentOrgId,token:this.token});const e=(await this.api.getCatalog()).map(n=>B(n));this.rawData=e,this.filteredData=e;const i=await this.api.getAllHealthScores();if(this.healthScores=i,this.fromUrlNavigation=!0,this.applyFiltersFromUrl(),this.fromUrlNavigation=!1,!this.domains||!this.groups||!this.systems){const{domains:n,groups:d,systems:c}=await H(this.api);this.domains=n,this.groups=d,this.systems=c}}}connectedCallback(){super.connectedCallback(),window.dispatchEvent(new CustomEvent("set-layout",{detail:"compact"})),window.addEventListener("popstate",this.handlePopState.bind(this))}disconnectedCallback(){super.disconnectedCallback(),window.dispatchEvent(new CustomEvent("set-layout",{detail:null})),window.removeEventListener("popstate",this.handlePopState.bind(this))}handleSearch(t){this.searchText=t.target.value.toLowerCase(),this.updateViewData()}handleFilterGroup(t){this.filterGroup=t,this.updateViewData()}handleFilterGrade(t){this.filterGrade=t,this.updateViewData()}handleFilterStage(t){this.filterStage=t,this.updateViewData()}handleFilterContact(t){this.filterContact=t,this.updateViewData()}handleFilterDomain(t){this.filterDomain=t,this.updateViewData()}handleFilterSystem(t){this.filterSystem=t,this.updateViewData()}handleFilterType(t){this.filterType=t,this.updateViewData()}handleFilterDataSensitivity(t){this.filterDataSensitivity=t,this.updateViewData()}handleFilterSourcingModel(t){this.filterSourcingModel=t,this.updateViewData()}handleFilterDeploymentModel(t){this.filterDeploymentModel=t,this.updateViewData()}handleFilterBusinessCriticality(t){this.filterBusinessCriticality=t,this.updateViewData()}handleFilterTags(t){this.filterTags=t,this.updateViewData()}handleSortOption(t){this.sortOption=t.target.value,this.updateViewData()}updateViewData(){this.filteredData=this.filterCatalog(this.filterGroup,this.filterGrade,this.filterStage,this.filterContact,this.filterDomain,this.filterSystem,this.filterType,this.filterDataSensitivity,this.filterSourcingModel,this.filterDeploymentModel,this.filterBusinessCriticality,this.filterTags),this.updateUrl(),this.requestUpdate()}applyFiltersFromUrl(){const t=new URLSearchParams(window.location.search),s=t.get("search");if(s){this.searchText=s.toLowerCase();const i=this.shadowRoot.querySelector("star-input");i&&(i.value=s)}this.filterGrade=this.getArrayParam(t,"grade"),this.filterDomain=this.getArrayParam(t,"domain"),this.filterSystem=this.getArrayParam(t,"system"),this.filterGroup=this.getArrayParam(t,"group"),this.filterContact=this.getArrayParam(t,"contact"),this.filterStage=this.getArrayParam(t,"stage"),this.filterType=this.getArrayParam(t,"type"),this.filterDataSensitivity=this.getArrayParam(t,"dataSensitivity"),this.filterSourcingModel=this.getArrayParam(t,"sourcing"),this.filterDeploymentModel=this.getArrayParam(t,"deployment"),this.filterBusinessCriticality=this.getArrayParam(t,"criticality"),this.filterTags=this.getArrayParam(t,"tags");const e=t.get("sort");if(e){this.sortOption=e;const i=this.shadowRoot.querySelector("star-select");i&&(i.value=e)}this.updateViewData()}getArrayParam(t,s){const e=t.get(s);return e?e.split(","):[]}updateUrl(){if(this.fromUrlNavigation)return;const t=new URLSearchParams;this.searchText&&t.set("search",this.searchText),this.addArrayParam(t,"grade",this.filterGrade),this.addArrayParam(t,"domain",this.filterDomain),this.addArrayParam(t,"system",this.filterSystem),this.addArrayParam(t,"group",this.filterGroup),this.addArrayParam(t,"contact",this.filterContact),this.addArrayParam(t,"type",this.filterType),this.addArrayParam(t,"stage",this.filterStage),this.addArrayParam(t,"dataSensitivity",this.filterDataSensitivity),this.addArrayParam(t,"sourcing",this.filterSourcingModel),this.addArrayParam(t,"deployment",this.filterDeploymentModel),this.addArrayParam(t,"criticality",this.filterBusinessCriticality),this.addArrayParam(t,"tags",this.filterTags),this.sortOption&&this.sortOption!=="none"&&t.set("sort",this.sortOption);const s=t.toString()?`?${t.toString()}`:window.location.pathname;window.history.pushState({path:s},"",s)}addArrayParam(t,s,e){e&&e.length>0&&t.set(s,e.join(","))}handlePopState(){this.fromUrlNavigation=!0,this.applyFiltersFromUrl(),this.fromUrlNavigation=!1}filterCatalog(t,s,e,i,n,d,c,h,p,g,m,u){const l=this.rawData.filter(r=>{const o=!this.searchText||r.name.toLowerCase().includes(this.searchText)||r.group.toLowerCase().includes(this.searchText),y=(t?.length??0)===0||t.includes(r.group),f=(s?.length??0)===0||s.includes(r.grade),S=(e?.length??0)===0||e.includes(r.stage),x=(i?.length??0)===0||i.some(z=>r.contacts?.map(({email:E})=>E).includes(z)),$=(n?.length??0)===0||n.includes(r.domain),w=(d?.length??0)===0||d.includes(r.system),D=(c?.length??0)===0||c.includes(r.kind),M=(h?.length??0)===0||h.includes(r.dataSensitivity),k=(p?.length??0)===0||p.includes(r.sourcingModel),G=(g?.length??0)===0||g.includes(r.deploymentModel),T=(m?.length??0)===0||m.includes(r.businessCriticality),N=(u?.length??0)===0||u.some(z=>(r.tags||[]).includes(z));return o&&y&&f&&S&&x&&$&&w&&D&&M&&k&&G&&T&&N});return this.sortOption==="date"?l.sort((r,o)=>parseInt(o.changed,10)-parseInt(r.changed,10)):this.sortOption==="grade"&&l.sort((r,o)=>r.grade.localeCompare(o.grade)),l}renderCatalog(){return this.filteredData.map(t=>{const s=this.healthScores?.filter(e=>e.id===t.id)?.[0];return a`<section>
        <catalog-record
          .data="${t}"
          .healthScore="${s}"
          .domains="${this.domains}"
          .groups="${this.groups}"
          .systems="${this.systems}"
        >
        </catalog-record>
      </section>`})}getSelectedFilters(){return(this.filterGroup?.length??0)+(this.filterGrade?.length??0)+(this.filterStage?.length??0)+(this.filterContact?.length??0)+(this.filterDomain?.length??0)+(this.filterSystem?.length??0)+(this.filterType?.length??0)+(this.filterDataSensitivity?.length??0)+(this.filterSourcingModel?.length??0)+(this.filterDeploymentModel?.length??0)+(this.filterBusinessCriticality?.length??0)+(this.filterTags?.length??0)}toggleEdit(){console.log("toggleEdit")}portal(){return a`
      <portal-entrance
        destination="actions"
        styles=${Y.cssText}
      >
        <div class="actions">
          ${a`
            <star-button
              size="small"
              @click=${this.toggleCreateRecordModal.bind(this)}
              variant="neutral"
              outline
            >
              <span slot="prefix" class="add">${K}</span>
              Add Record
            </star-button>
          `}
        </div>
      </portal-entrance>`}render(){if(!this.filteredData)return a`<spinner-component></spinner-component>`;const t=this.getSelectedFilters(),s=`Filter${t>0?` (${t})`:""}`;return a`
      ${this.portal()}

      <div class="filter-bar">
        <star-input
          type="text"
          size="small"
          placeholder="Search services..."
          @input="${this.handleSearch.bind(this)}"
        >
          <span slot="suffix">${I}</span>
        </star-input>

        <sl-dropdown
          label="Filter"
          id="filter-drawer"
          distance="8"
          skidding="-8"
          placement="bottom-start"
        >
          <star-tag slot="trigger" value="${s}" style="filter" class="filter${t>0?" active":""}"></star-tag>

          <catalog-filter
            .catalogData="${this.rawData}"
            .domains="${this.domains}"
            .groups="${this.groups}"
            .systems="${this.systems}"
            .filterCatalog="${this.filterCatalog.bind(this)}"
            .handleFilterGroup="${this.handleFilterGroup.bind(this)}"
            .handleFilterGrade="${this.handleFilterGrade.bind(this)}"
            .handleFilterStage="${this.handleFilterStage.bind(this)}"
            .handleFilterContact="${this.handleFilterContact.bind(this)}"
            .handleFilterDomain="${this.handleFilterDomain.bind(this)}"
            .handleFilterSystem="${this.handleFilterSystem.bind(this)}"
            .handleFilterType="${this.handleFilterType.bind(this)}"
            .handleFilterDataSensitivity="${this.handleFilterDataSensitivity.bind(this)}"
            .handleFilterSourcingModel="${this.handleFilterSourcingModel.bind(this)}"
            .handleFilterDeploymentModel="${this.handleFilterDeploymentModel.bind(this)}"
            .handleFilterBusinessCriticality="${this.handleFilterBusinessCriticality.bind(this)}"
            .handleFilterTags="${this.handleFilterTags.bind(this)}"
            .handleSortOption="${this.handleSortOption.bind(this)}"
            .selectedGroups="${this.filterGroup}"
            .selectedGrades="${this.filterGrade}"
            .selectedStages="${this.filterStage}"
            .selectedContacts="${this.filterContact}"
            .selectedDomains="${this.filterDomain}"
            .selectedSystems="${this.filterSystem}"
            .selectedTypes="${this.filterType}"
            .selectedDataSensitivities="${this.filterDataSensitivity}"
            .selectedSourcingModels="${this.filterSourcingModel}"
            .selectedDeploymentModels="${this.filterDeploymentModel}"
            .selectedBusinessCriticality="${this.filterBusinessCriticality}"
            .selectedTags="${this.filterTags}"
          ></catalog-filter>
        </sl-dropdown>

        <star-button
          @click="${this.toggleShareViewModal.bind(this)}"
          variant="neutral"
          size="small"
        >
          Share this view
        </star-button>

        <star-select
          @sl-change="${e=>this.handleSortOption(e)}"
          clearable
          size="small"
          placeholder="Sort by..."
          max-options-visible="2"
        >
          <star-option value="none">No Sorting</star-option>
          <star-option value="date">Sort by Date</star-option>
          <star-option value="grade">Sort by Grade</star-option>
        </star-select>
      </div>

      <star-divider></star-divider>

      <div id="catalog">${this.renderCatalog()}</div>

      <star-dialog
        label="Create Record"
        id="create-record-modal"
        ?open=${this.isCreateRecordModalOpen}
        @sl-after-hide=${()=>this.isCreateRecordModalOpen=!1}
      >
        ${this.isCreateRecordModalOpen?a`
          <create-record
            .organizationId=${this.user.currentOrgId}
            .token=${this.token}
            .onCreate=${this.onCreate.bind(this)}
            .onCancel=${this.toggleCreateRecordModal.bind(this)}
          ></create-record>
        `:""}
      </star-dialog>

      <star-dialog label="Share View" id="share-view-modal">
        <share-view
          .onCancel=${this.toggleShareViewModal.bind(this)}
        ></share-view>
      </star-dialog>
    `}toggleSearch(){this.shadowRoot.querySelector("#search-drawer").open=!this.shadowRoot.querySelector("#search-drawer").open}toggleFilter(){this.shadowRoot.querySelector("#filter-drawer").open=!this.shadowRoot.querySelector("#filter-drawer").open}toggleCreateRecordModal(){this.isCreateRecordModalOpen=!this.isCreateRecordModalOpen}toggleShareViewModal(){this.shadowRoot.querySelector("#share-view-modal").open=!this.shadowRoot.querySelector("#share-view-modal").open}onCreate(t){this.rawData=[B(t),...this.rawData],this.updateViewData(),this.toggleCreateRecordModal()}}customElements.define("catalog-view",et);export{et as CatalogView};
