import{a as f,i as h,x as a,b as v}from"./vendor-uqDZySxZ.js";import{a as b}from"./actions-DQjIolQK.js";import{a as u,A as k,c as C}from"./index-CAeYBYQn.js";import{c as p}from"./cross-BB59dYvr.js";import{g as y}from"./getLastPathSegment-X_L89kGh.js";import{d as w,p as x,c as P}from"./pencil-CZnI5oIP.js";import"./shoelace-VCI8xL3U.js";class E extends f{static styles=h`
    :host {
      width: 100%;
    }
    .baseline-input-container {
      display: flex;
      align-items: flex-end;
      gap: var(--sl-spacing-medium);
      margin-bottom: var(--sl-spacing-medium);
      flex-wrap: wrap;
    }
    .baseline-properties {
      margin-bottom: var(--sl-spacing-2x-large);
    }
    star-input {
      flex: 1;
      min-width: 300px;
    }

    star-input[label="Baseline ID"] {
      flex: 0 1 25%;
      min-width: 150px;
    }

    @media (max-width: 768px) {
      star-input {
        flex: 1 1 100%;
        min-width: 100%;
      }

      star-input[label="Baseline ID"] {
        flex: 1 1 100%;
        min-width: 100%;
      }
    }
  `;static properties={isEditing:{type:Boolean},baseline:{type:Object},onChange:{type:Function}};handleNameChange(e){const s=e.target.value,t={...this.baseline,name:s};this.emitBaselineChange(t)}handleDescriptionChange(e){this.baseline.description=e.target.value,this.onChange(this.baseline)}emitBaselineChange(e){this.dispatchEvent(new CustomEvent("baseline-changed",{detail:e,bubbles:!0,composed:!0}))}render(){if(!this.baseline)return;const{name:e,id:s}=this.baseline;return a`
      <h1>${this.baseline.name}</h1>

      <div class="baseline-properties">
        <div class="baseline-input-container">
          <star-input
            label="Baseline Name"
            value=${e}
            ?disabled=${!this.isEditing}
            @sl-input=${this.handleNameChange}
          ></star-input>

          <star-input
            label="Baseline ID"
            value=${s}
            disabled
          ></star-input>

          <sl-copy-button
            value="${s}"
            copy-label="Click to copy"
            success-label="Copied Baseline ID"
            error-label="Your browser doesn't support this!"
          ></sl-copy-button>
        </div>

        <star-textarea
          placeholder="Add description..."
          label="Description"
          value=${this.baseline.description}
          ?disabled=${!this.isEditing}
          @input=${this.handleDescriptionChange.bind(this)}
        >
        </star-textarea>
      </div>
    `}}customElements.define("baseline-general",E);const $=v`<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="inherit"><path fill="currentColor" fill-rule="evenodd" d="M7.5.877a6.623 6.623 0 1 0 0 13.246A6.623 6.623 0 0 0 7.5.877ZM1.827 7.5a5.673 5.673 0 1 1 11.346 0 5.673 5.673 0 0 1-11.346 0Zm6.423-3a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6 6h1.5a.5.5 0 0 1 .5.5V10h1v1H6v-1h1V7H6V6Z" clip-rule="evenodd"/></svg>`,I=v`<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15" fill="none">
<path d="M8.4449 0.608765C8.0183 -0.107015 6.9817 -0.107015 6.55509 0.608766L0.161178 11.3368C-0.275824 12.07 0.252503 13 1.10608 13H13.8939C14.7475 13 15.2758 12.07 14.8388 11.3368L8.4449 0.608765ZM7.4141 1.12073C7.45288 1.05566 7.54712 1.05566 7.5859 1.12073L13.9798 11.8488C14.0196 11.9154 13.9715 12 13.8939 12H1.10608C1.02849 12 0.980454 11.9154 1.02018 11.8488L7.4141 1.12073ZM6.8269 4.48611C6.81221 4.10423 7.11783 3.78837 7.5 3.78837C7.88217 3.78837 8.18779 4.10423 8.1731 4.48611L8.01921 8.48611C8.00848 8.766 7.7792 8.98837 7.5 8.98837C7.2208 8.98837 6.99151 8.766 6.98078 8.48611L6.8269 4.48611ZM8.24989 10.476C8.24989 10.8902 7.9141 11.226 7.49989 11.226C7.08567 11.226 6.74989 10.8902 6.74989 10.476C6.74989 10.0618 7.08567 9.72599 7.49989 9.72599C7.9141 9.72599 8.24989 10.0618 8.24989 10.476Z" fill="currentColor" fill-rule="evenodd" clip-rule="evenodd"/>
</svg>`,o={severities:[{value:"warning",label:"Warning",icon:I},{value:"error",label:"Error",icon:p}],configuration:{checkForConflictingLockfiles:{name:"Conflicting Lock Files",tooltip:"Checks if there are conflicting Node package lock files (i.e. both a Yarn lock file and an NPM lock file).",check:{name:"checkForConflictingLockfiles",severity:"error",path:""},acceptsIgnorePaths:!1},checkForConsoleUsage:{name:"No Using Console",tooltip:"Checks if console is used, e.g. console.log() and similar. This is useful when you want to ensure a more comprehensive logging approach is used. Note that this uses a naive solution so even just a mention of console.log() (or similar) will fail this check. Will respect ignorePaths options.",check:{name:"checkForConsoleUsage",severity:"error",path:"/src",ignorePaths:[]},acceptsIgnorePaths:!0},checkForDefinedRelations:{name:"Defined Relations",tooltip:"Checks if the service metadata defines system relations.",check:{name:"checkForDefinedRelations",severity:"error",path:"manifest.json"},acceptsIgnorePaths:!1},checkForDefinedServiceLevelObjectives:{name:"Defined Service Level Objectives",tooltip:"Checks if the service metadata defines Service Level Objectives.",check:{name:"checkForDefinedServiceLevelObjectives",severity:"error",path:"manifest.json"},acceptsIgnorePaths:!1},checkForDefinedTags:{name:"Defined Tags",tooltip:"Checks if the service metadata defines tags.",check:{name:"checkForDefinedTags",severity:"error",path:"manifest.json"},acceptsIgnorePaths:!1},checkForPresenceApiSchema:{name:"API Schema Exists",tooltip:"Checks if there is an API schema.",check:{name:"checkForPresenceApiSchema",severity:"error",path:"api/schema.json"},acceptsIgnorePaths:!1},checkForPresenceChangelog:{name:"Changelog Exists",tooltip:"Checks if there is a CHANGELOG.md file.",check:{name:"checkForPresenceChangelog",severity:"error",path:""},acceptsIgnorePaths:!1},checkForPresenceCiConfig:{name:"CI Configuration Exists",tooltip:"Checks if there is a CI/CD configuration file.",check:{name:"checkForPresenceCiConfig",severity:"error",path:".github/workflows/main.yml"},acceptsIgnorePaths:!1},checkForPresenceCodeowners:{name:"CODEOWNERS File Exists",tooltip:"Checks if there is a CODEOWNERS file.",check:{name:"checkForPresenceCodeowners",severity:"error",path:""},acceptsIgnorePaths:!1},checkForPresenceContributing:{name:"CONTRIBUTING File Exists",tooltip:"Checks if there is a CONTRIBUTING.md file.",check:{name:"checkForPresenceContributing",severity:"error",path:""},acceptsIgnorePaths:!1},checkForPresenceDiagramsFolder:{name:"Diagrams Folder Exists",tooltip:"Checks if there is a diagrams folder with diagram files in it. The check assumes .drawio files.",check:{name:"checkForPresenceDiagramsFolder",severity:"error",path:"/diagrams"},acceptsIgnorePaths:!1},checkForPresenceIacConfig:{name:"Infrastructure as Code Configuration Exists",tooltip:"Checks if there is Infrastructure-as-Code configuration present.",check:{name:"checkForPresenceIacConfig",severity:"error",path:"serverless.yml"},acceptsIgnorePaths:!1},checkForPresenceLicense:{name:"LICENSE File Exists",tooltip:"Checks if there is a LICENSE.md file.",check:{name:"checkForPresenceLicense",severity:"error",path:""},acceptsIgnorePaths:!1},checkForPresenceReadme:{name:"README File Exists",tooltip:"Checks if there is a README.md file.",check:{name:"checkForPresenceReadme",severity:"error",path:""},acceptsIgnorePaths:!1},checkForPresenceSecurity:{name:"SECURITY File Exists",tooltip:"Checks if there is a SECURITY.md file.",check:{name:"checkForPresenceSecurity",severity:"error",path:""},acceptsIgnorePaths:!1},checkForPresenceServiceMetadata:{name:"Service Metadata Exists",tooltip:"Checks if there a service metadata file present.",check:{name:"checkForPresenceServiceMetadata",severity:"error",path:"manifest.json"},acceptsIgnorePaths:!1},checkForPresenceTemplateIssues:{name:"Issue Template Exists",tooltip:"Checks if there is a template for GitHub issues.",check:{name:"checkForPresenceTemplateIssues",severity:"error",path:".github/ISSUE_TEMPLATE/issue.md"},acceptsIgnorePaths:!1},checkForPresenceTemplatePullRequests:{name:"Pull Request Template Exists",tooltip:"Checks if there is a template for GitHub Pull Requests.",check:{name:"checkForPresenceTemplatePullRequests",severity:"error",path:".github/ISSUE_TEMPLATE/pull_request.md"},acceptsIgnorePaths:!1},checkForPresenceTests:{name:"Tests Exist",tooltip:"Checks if there are any tests in the provided location. This will match anything ending in (test|spec).(ts|js). Will respect ignorePaths options.",check:{name:"checkForPresenceTests",severity:"error",path:"/tests",ignorePaths:[]},acceptsIgnorePaths:!0},checkForThrowingPlainErrors:{name:"No Throwing Plain Errors",tooltip:"Checks if any file uses throw Error or throw new Error. This is meant to push toward the use of actual loggers, rather than plain console output. Will respect ignorePaths options.",check:{name:"checkForThrowingPlainErrors",severity:"error",path:"",ignorePaths:[]},acceptsIgnorePaths:!0}}};class F extends u{static styles=h`
    .table-filter {
      margin: 0 0 var(--sl-spacing-large) 0;
      display: flex;
      .filter-text {
        width: 30%;
        min-width: 240px;
        margin-right: var(--sl-spacing-medium);
      }
    }

    a {
      color: white;
    }

    .header {
      display: flex;
      justify-content: space-between;
      align-items: center;

      star-button {
        span {
          display: flex;
          svg path {
            fill: var(--sl-color-primary-950);
          }
        }
      }
    }

    section {
      margin: var(--sl-spacing-x-large) 0;
    }

    .grid-table {
      display: grid;
      grid-template-columns: 10% 20% 10% 25% 25%;
      width: 100%;
    }

    .grid-header {
      display: contents;
    }

    .grid-header-cell {
      padding: var(--sl-spacing-x-small) 0;
      border-bottom: 1px solid var(--color-divider);
      font-weight: var(--sl-font-weight-semibold);
      text-align: left;
    }

    .grid-row {
      display: contents;
    }

    .grid-row:hover .grid-cell {
      background-color: var(--sl-color-neutral-50);
    }

    .grid-cell {
      width: 100%;
      border-bottom: 1px solid var(--color-divider);
      display: flex;
      align-items: center;
      gap: var(--sl-spacing-x-small);
      min-height: 3rem;
      height: auto;
      padding-right: var(--sl-spacing-small);

      .grid-cell-text-content {
        flex: 1;
        min-width: 0;
        text-overflow: ellipsis;
        overflow: hidden;
        white-space: nowrap;
        margin-right: 1rem;
      }

      svg {
        margin-right: 1rem;
      }

      sl-input, sl-select {
        width: 100%;
      }

      sl-tooltip {
        position: relative;
        z-index: 1;
        flex-shrink: 0;

        svg {
          display: block;
        }
      }
    }

    .severity-label {
      display: flex;
      align-items: center;
      gap: 0.5rem;
      min-width: 0; /* Critical for ellipsis in flex container */
      overflow: hidden; /* Needed for ellipsis */
    }

    .severity-text {
      text-overflow: ellipsis;
      overflow: hidden;
      white-space: nowrap;
      min-width: 0; /* Critical for text to shrink */
    }

    .severity-icon {
      width: 1rem;
      height: 1rem;
      flex-shrink: 0;
    }

    .severity-icon svg {
      width: 100%;
      height: 100%;
      display: block;
    }

    .code {
      font-family: ui-monospace, 'Cascadia Code', 'Source Code Pro', Menlo, Consolas, 'DejaVu Sans Mono', monospace;
    }
  `;static properties={isEditing:{type:Boolean},checks:{type:Array},baseline:{type:Object}};handleCheckboxChange(e,s){const t=e.target.checked,i={...this.baseline};if(t){if(!i.checks.find(l=>l.name===s)){const l=o.configuration[s],c={name:s,severity:l?.defaultSeverity||o.severities[0].value,path:"",ignorePaths:""};i.checks.push(c)}}else i.checks=i.checks.filter(r=>r.name!==s);this.emitBaselineChange(i)}handleSeverityChange(e,s){const t=e.target.value,i={...this.baseline},r=i.checks.findIndex(l=>l.name===s);r!==-1&&(i.checks[r]={...i.checks[r],severity:t},this.emitBaselineChange(i))}handlePathChange(e,s){const t=e.target.value,i={...this.baseline},r=i.checks.findIndex(l=>l.name===s);r!==-1&&(i.checks[r]={...i.checks[r],path:t},this.emitBaselineChange(i))}handleIgnorePathsChange(e,s){const t=e.target.value,i={...this.baseline},r=i.checks.findIndex(l=>l.name===s);r!==-1&&(i.checks[r]={...i.checks[r],ignorePaths:t},this.emitBaselineChange(i))}emitBaselineChange(e){this.dispatchEvent(new CustomEvent("baseline-changed",{detail:e,bubbles:!0,composed:!0}))}render(){return!this.checks||!this.baseline?a`<spinner-component></spinner-component>`:a`
      <div class="grid-table" role="table" aria-label="Checks configuration table">
        <div class="grid-header" role="rowgroup">
          <div class="grid-header-cell" role="columnheader">Active?</div>
          <div class="grid-header-cell" role="columnheader">Check Name</div>
          <div class="grid-header-cell" role="columnheader">Severity</div>
          <div class="grid-header-cell" role="columnheader">Path</div>
          <div class="grid-header-cell" role="columnheader">${this.isEditing?"Ignore Paths (comma-separated)":"Ignore Paths"}</div>
        </div>

        ${this.checks.map(e=>{const s=e.name,t=this.baseline.checks.find(n=>n.name===s)||{},i=o.configuration[s],{name:r,tooltip:l,acceptsIgnorePaths:c}=i,d=t.name!==void 0,m=t.path||i.check.path;return a`
            <div class="grid-row" role="rowgroup">
              <div class="grid-cell" role="gridcell" data-label="Active?">
                <sl-checkbox
                  ?checked="${d}"
                  ?disabled="${!this.isEditing}"
                  @sl-change="${n=>this.handleCheckboxChange(n,s)}"
                ></sl-checkbox>
              </div>

              <div class="grid-cell" role="gridcell" data-label="Check Name">
                <span class="grid-cell-text-content">${r}</span>

                <sl-tooltip content="${l}">
                  ${$}
                </sl-tooltip>
              </div>

              <div class="grid-cell" role="gridcell" data-label="Severity">
              ${this.isEditing&&d?a`<star-select
                      value="${t.severity||o.severities[0].value}"
                      @sl-change="${n=>this.handleSeverityChange(n,s)}"
                    >
                    ${o.severities.map(n=>a`
                        <star-option value="${n.value}">
                          <span class="severity-label">
                            <span class="severity-icon">${n.icon}</span>
                            ${n.label}
                          </span>
                        </star-option>
                      `)}
                  </star-select>`:d?a`
                        <span class="severity-label grid-cell-text-content">
                          <span class="severity-icon">
                            ${o.severities.find(n=>n.value===t?.severity)?.icon||""}
                          </span>
                          <span class="severity-text">${o.severities.find(n=>n.value===t?.severity)?.label||o.severities[0].label}</span>
                        </span>
                      `:a`${t.severity}`}
              </div>

              <div class="grid-cell code" role="gridcell" data-label="Path">
                ${this.isEditing?a`<sl-input
                        value="${t.path||""}"
                        @sl-input="${n=>this.handlePathChange(n,s)}"
                        placeholder="${m}"
                      ></sl-input>`:a`<span class="grid-cell-text-content">${m}</span>`}
              </div>

              <div class="grid-cell" role="gridcell" data-label="Ignore Paths">
                ${this.isEditing&&c?a`<sl-input
                        value="${t.ignorePaths||""}"
                        @sl-input="${n=>this.handleIgnorePathsChange(n,s)}"
                        placeholder="path1, path2, path3..."
                      ></sl-input>`:c&&t.ignorePaths?a`${t.ignorePaths}`:c?a`—`:a`<em>Not applicable</em>`}
              </div>
            </div>
          `})}
      </div>
    `}}window.customElements.define("checks-table",F);class S extends u{static styles=h`
    .header {
      display: flex;
      justify-content: space-between;
      align-items: center;

      star-button {
        span {
          display: flex;
          svg path {
            fill: var(--sl-color-primary-950);
          }
        }
      }
    }

    section {
      margin: var(--sl-spacing-x-large) 0;
    }

    .table {
      margin-top: 3rem;
    }

    svg {
      path {
        fill: var(--sl-color-gray-800);
      }
    }

    .baselines {
      width: 100%;
      font-size: var(--sl-font-size-small);
      border-collapse: collapse;
      margin-top: var(--sl-spacing-medium);
      isolation: isolate; /* Add this - creates new stacking context */

      thead {
        tr {
          border-bottom: 2px solid var(--color-divider);
        }

        th {
          text-align: left;
          padding: var(--sl-spacing-small) var(--sl-spacing-medium);
          font-weight: 600;
          color: var(--sl-color-gray-700);

          &:last-child {
            width: 60px;
            text-align: center;
          }
        }
      }

      tbody {
        tr {
          border-bottom: 1px solid var(--color-divider);

          &:last-child {
            border-bottom: none;
          }

          &:hover {
            background-color: var(--sl-color-gray-200);
            transition: 0.2s;
          }
        }

        td {
          padding: var(--sl-spacing-small) var(--sl-spacing-medium);
          height: 3rem;
          vertical-align: middle;

          &.actions {
            text-align: left;
          }
        }
      }
    }

    .empty-state {
      text-align: center;
      padding: var(--sl-spacing-x-large);
      color: var(--sl-color-gray-600);
      margin-top: var(--sl-spacing-medium);
    }
  `;actionsStyles=h`
    .actions {
      display: flex;
      flex-direction: row;
    }

    .actions-toggle {
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      width: 30px;
      height: 30px;
      box-sizing: border-box;
      border: 1px solid var(--color-divider);
      border-radius: var(--sl-border-radius-medium);
    }

    sl-menu {
      padding: var(--sl-spacing-x-small) 0;
    }

    star-button {
      margin-right: var(--sl-spacing-x-small);
    }

    star-button span {
      display: flex;
    }

    sl-dropdown {
      z-index: 10;
    }

    .id {
      font-family: ui-monospace, 'Cascadia Code', 'Source Code Pro', Menlo, Consolas, 'DejaVu Sans Mono', monospace;
    }
  `;static properties={id:{type:String},baseline:{type:Object},isEditing:{type:Boolean}};constructor(){super(),this.checks=Object.values(o.configuration).map(e=>e.check)}async updated(e){if(e.has("user")){this.id=y(),this.api=new k({isLocal:!1,organizationId:this.user.currentOrgId,token:this.token});const s=window.location.pathname.split("/").pop();this.baseline=await this.api.getBaseline(s),this.rawBaseline=JSON.parse(JSON.stringify(this.baseline))}}portal(){return a`
      <portal-entrance
        destination="actions"
        styles=${b.cssText}
      >
        <div class="actions">
          ${a`
            <star-button
              variant="neutral"
              size="small"
              @click=${()=>this.removeBaseline()}
            >
              <span slot="prefix">${p}</span>
              Remove Baseline
            </star-button>
          `}
        </div>
      </portal-entrance>`}render(){return this.baseline?a`
      ${this.portal()}

      <section class="baselines">
        <div class="header">
          <baseline-general
            .isEditing="${this.isEditing}"
            .baseline="${this.baseline}"
            .onChange="${this.onChange.bind(this)}"
            @baseline-changed="${this.handleBaselineChange}"
          ></baseline-general>
        </div>

        <checks-table
          .isEditing="${this.isEditing}"
          .checks="${this.checks}"
          .baseline="${this.baseline}"
          @baseline-changed="${this.handleBaselineChange}"
        ></checks-table>
      </section>

      <portal-entrance
        destination="actions"
        styles=${this.actionsStyles.cssText}
      >
        <div class="actions">
          ${this.isEditing?a`
                  <star-button
                    variant="neutral"
                    size="small"
                    @click=${this.cancelEdit.bind(this)}
                  >
                    <span slot="prefix">${p}</span>
                    Cancel
                  </star-button>
                  <star-button
                    variant="primary"
                    size="small"
                    @click=${this.saveEdit.bind(this)}
                    ?disabled=${!this.hasChanged()}
                  >
                    <span slot="prefix">${P}</span>
                    Save
                  </star-button>
                `:a`
                  <star-button
                    variant="neutral"
                    size="small"
                    outline
                    @click=${this.toggleEdit.bind(this)}
                  >
                    <span slot="prefix">${x}</span>
                    Edit Baseline
                  </star-button>
                `}

          <sl-dropdown distance="5" skidding="5">
            <div class="actions-toggle" slot="trigger">${w}</div>

            <sl-menu>
              <star-menu-item @click=${this.toggleRemove.bind(this)}>
                Remove Baseline
              </star-menu-item>
            </sl-menu>
          </sl-dropdown>

        </div>
      </portal-entrance>

      <star-dialog label="Remove ${this.baseline.name}">
        <span>
          Are you sure you want to delete this baseline? The action cannot be undone.
        </span>

        <div class="footer" slot="footer">
          <star-button
            variant="neutral"
            size="small"
            @click=${this.toggleRemove.bind(this,null)}
            >Cancel</star-button
          >

          <star-button
            variant="danger"
            size="small"
            @click=${this.removeBaseline.bind(this)}
            >Remove</star-button
          >
        </div>
      </star-dialog>
    `:a`<spinner-component></spinner-component>`}toggleRemove(){this.shadowRoot.querySelector("star-dialog").open=!this.shadowRoot.querySelector("star-dialog").open}async removeBaseline(){await this.api.deleteBaseline(this.baseline.id),window.location.href=`${C(!1).appBase}/baselines`}async toggleEdit(){this.isEditing=!this.isEditing}cancelEdit(){this.isEditing=!1,this.baseline=JSON.parse(JSON.stringify(this.rawBaseline))}async saveEdit(){this.isEditing=!1,await this.api.updateBaseline(this.baseline.id,this.baseline),this.rawBaseline=JSON.parse(JSON.stringify(this.baseline))}handleBaselineChange(e){this.baseline={...this.baseline,...e.detail},this.requestUpdate()}onChange(e){this.baseline=e,this.requestUpdate("baseline")}hasChanged(){return JSON.stringify(this.baseline)!==JSON.stringify(this.rawBaseline)}}window.customElements.define("baseline-view",S);export{S as BaselineView};
